import sys
from collections import defaultdict
from bisect import bisect_left

def count_pairs_greater(list1, list2):
    total = 0
    for val in list1:
        idx = bisect_left(list2, val + 1)
        total += len(list2) - idx
    return total

data = sys.stdin.read().split()
N = int(data[0])
points = []
index = 1
for i in range(N):
    x = int(data[index])
    y = int(data[index + 1])
    points.append((x, y))
    index += 2

vert = defaultdict(lambda: {'N': [], 'S': []})
horiz = defaultdict(lambda: {'E': [], 'W': []})
ne = defaultdict(lambda: {'N': [], 'E': []})
nw = defaultdict(lambda: {'N': [], 'W': []})
se = defaultdict(lambda: {'S': [], 'E': []})
sw = defaultdict(lambda: {'S': [], 'W': []})

for x, y in points:
    vert[x]['N'].append(y)
    vert[x]['S'].append(y)
    horiz[y]['E'].append(x)
    horiz[y]['W'].append(x)
    s = x + y
    ne[s]['N'].append(y)
    ne[s]['E'].append(y)
    d = y - x
    nw[d]['N'].append(y)
    nw[d]['W'].append(y)
    se[d]['S'].append(y)
    se[d]['E'].append(y)
    sw[s]['S'].append(y)
    sw[s]['W'].append(y)

total = 0

# Vertical
for x in vert:
    north = sorted(vert[x]['N'])
    south = sorted(vert[x]['S'])
    north_even = [y for y in north if y % 2 == 0]
    north_odd = [y for y in north if y % 2 == 1]
    south_even = [y for y in south if y % 2 == 0]
    south_odd = [y for y in south if y % 2 == 1]
    for yn in north_even:
        idx = bisect_left(south_even, yn + 1)
        total += len(south_even) - idx
    for yn in north_odd:
        idx = bisect_left(south_odd, yn + 1)
        total += len(south_odd) - idx
    for ys in south_even:
        idx = bisect_left(north_even, ys + 1)
        total += len(north_even) - idx
    for ys in south_odd:
        idx = bisect_left(north_odd, ys + 1)
        total += len(north_odd) - idx

# Horizontal
for y in horiz:
    east = sorted(horiz[y]['E'])
    west = sorted(horiz[y]['W'])
    east_even = [x for x in east if x % 2 == 0]
    east_odd = [x for x in east if x % 2 == 1]
    west_even = [x for x in west if x % 2 == 0]
    west_odd = [x for x in west if x % 2 == 1]
    for xe in east_even:
        idx = bisect_left(west_even, xe + 1)
        total += len(west_even) - idx
    for xe in east_odd:
        idx = bisect_left(west_odd, xe + 1)
        total += len(west_odd) - idx
    for xw in west_even:
        idx = bisect_left(east_even, xw + 1)
        total += len(east_even) - idx
    for xw in west_odd:
        idx = bisect_left(east_odd, xw + 1)
        total += len(east_odd) - idx

# N and E
for s in ne:
    north_y = sorted(ne[s]['N'])
    east_y = sorted(ne[s]['E'])
    total += count_pairs_greater(north_y, east_y)

# N and W
for d in nw:
    north_y = sorted(nw[d]['N'])
    west_y = sorted(nw[d]['W'])
    total += count_pairs_greater(north_y, west_y)

# S and E
for d in se:
    south_y = sorted(se[d]['S'])
    east_y = sorted(se[d]['E'])
    total += count_pairs_greater(south_y, east_y)

# S and W
for s in sw:
    south_y = sorted(sw[s]['S'])
    west_y = sorted(sw[s]['W'])
    total += count_pairs_greater(south_y, west_y)

print(total)